import java.util.*;
import java.io.*;

class MGParameters extends Parameters {
    
    /*****************************************************************/
    /*                     Instance Variables                        */
    /*****************************************************************/

    // All instance variables are public.  This is a thin class.
    // How should we initialize the assignments:
    //    allOnes
    //    nGroups
    //    sampling
    String initializationType_;

    /*****************************************************************/
    /*                            Methods                            */
    /*****************************************************************/

    /**
     * Simple default constructor.
     */
    public MGParameters() {
	SetToDefault();
    }

    /**
     * Construct from file.
     */
    public MGParameters(String parameterFile) {
	LoadFromFile(parameterFile);
    }

    /**
     * Choose a default set of parameters.
     */
    public void SetToDefault() {
	initializationType_ = "nGroups";
    }

    /**
     * Given a filename, load parameters.  The file should be a text file
     * of the following form:
     * <parameter1_name> <parameter1_value>
     * ...
     * <parameterN_name> <parameterN_value>
     */
    public void LoadFromFile(String filename) {
	try {
	    BufferedReader input = 
		new BufferedReader(new FileReader(filename));

	    // There's just one line to read
	    String line ;
	    while ( (line = input.readLine()) != null ) {
		String[] entries = line.trim().split("\\s+");		
		
		// Allow blank lines
		if (entries.length == 0) continue;
		
		// Otherwise, there must be 2 entries per line
		assert(entries.length == 2);

		if (entries[0].equals("initializationType")) {
		    initializationType_ = entries[1];
		} else {
		    System.err.println("Warning: unknown parameter " +
				       entries[0] + ", value = " + entries[1]);
		}
	    }
	}
	catch (Exception ex){
	    ex.printStackTrace();
	    System.exit(1);
	}	
    }

    /**
     * Filename portion for algorithm specific parameters
     */
    public String FileName() {
	String filename = "";
	filename += "init_" + initializationType_;
	
	return filename;
    }

}
